/*---------------------------------------------------------------------------*\

    FILE....: TVPB8L.CPP
    TYPE....: C++ Console program
    AUTHOR..: David Rowe
    DATE....: 28/02/01

    This program tests the VPB8L, recording all 8 channels to disk files using
    VOX.

    Compile: gcc tvpb8l.cpp -o tvpb8l ../linux/libvpb.a -pthread -lm -Wall -g
    Run: ./tvpb8l
 	 
\*---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*\

         Voicetronix Voice Processing Board (VPB) Software

         Copyright (C) 1999-2001 Voicetronix www.voicetronix.com.au

         This library is free software; you can redistribute it and/or
         modify it under the terms of the GNU Lesser General Public
         License as published by the Free Software Foundation; either
         version 2.1 of the License, or (at your option) any later version.

         This library is distributed in the hope that it will be useful,
         but WITHOUT ANY WARRANTY; without even the implied warranty of
         MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
         Lesser General Public License for more details.

         You should have received a copy of the GNU Lesser General Public
         License along with this library; if not, write to the Free Software
         Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
	 USA

\*---------------------------------------------------------------------------*/

#define NUM_CH 8

#include <assert.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include "../src/vpbapi.h"
#include "../src/verbose.h"
#include "../src/mess.h"

int arg_exists(int argc, char *argv[], char *arg);

int overwrite;
int serial[NUM_CH];

void WINAPI callback(VPB_EVENT *e, void *context) {
	char  s[VPB_MAX_STR];
	char  filename[VPB_MAX_STR];
	int h;

	h= *((int *)context);

	vpb_translate_event(e, s);
	mprintf("%s",s);

	switch(e->type) {
        case VPB_VOXON :
		if (overwrite) {
		  sprintf(filename,"file%d.wav",h);
		}
		else {
		  sprintf(filename,"file%d_%d.wav", h, serial[h]++);
		}
		  
		vpb_record_file_async(h, filename, VPB_LINEAR);
		break;

        case VPB_VOXOFF :
		vpb_record_terminate(h);

        case VPB_RECORDEND :
		break;

	default :
		break;

	}
}

int main(int argc, char *argv[]) {
	int         h[NUM_CH];
	VPB_VOX	    v;
	int         i;

	if (arg_exists(argc, argv, "-no") != 0) {
	  overwrite = 0;
	}
	else {
	  overwrite = 1;
	}

	vpb_seterrormode(VPB_DEVELOPMENT);
	verbose(1);

	v.runon = 5000;
	v.onlevel = -40;
	v.offlevel = -45;
    
	for(i=0; i<NUM_CH; i++) {
		h[i] = vpb_open(1,i+1);
		vpb_setvox(h[i], &v);
		vpb_set_event_callback(h[i], callback, (void*)&h[i]);
	}

	vpb_getvox(h[0], &v);
	printf("on level = %f dB  off level = %f dB  run on = %d ms\n",
	       v.onlevel,v.offlevel,v.runon);

	printf("Press return to exit\n");
	getchar();

	for(i=0; i<NUM_CH; i++) {
		vpb_close(h[i]);
	}

	return 0;
}

int arg_exists(int argc, char *argv[], char *arg) {
  int i;

  for(i=0; i<argc; i++)
    if (strcmp(argv[i],arg) == 0)
      return i;

  return 0;
}
